/*

Basic AI for Guardian Constrictor IIg

*/

"use strict";

this.name = "Elite Trader Guardian Constrictor AI";

this.aiStarted = function() {
	var ai = new worldScripts["oolite-libPriorityAI"].PriorityAIController(this.ship);

	ai.setParameter("oolite_flag_listenForDistressCall",true);
	ai.setParameter("oolite_flag_surrendersLate",true);
	ai.setCommunicationsRole("_constrictor");

	ai.setPriorities([
		/* Fight */
		{
			preconfiguration: function() 
			{
				if (this.ship.script._checkDistance)
				{
					this.ship.script._checkDistance();
				}
			},
			condition: ai.conditionLosingCombat,
			behaviour: ai.behaviourFleeCombat,
			reconsider: 20
		},
		{
			condition: ai.conditionInCombat,
			configuration: ai.configurationAcquireCombatTarget,
			behaviour: ai.behaviourDestroyCurrentTarget,
			reconsider: 5
		},
		/* Check for distress calls */
		{
			condition: ai.conditionHasReceivedDistressCall,
			behaviour: ai.behaviourRespondToDistressCall,
			reconsider: 20
		},
		/* Return to witchpoint */
		{
			configuration: ai.configurationSetDestinationToWitchpoint,
			behaviour: ai.behaviourApproachDestination,
			reconsider: 5
		}
	]);
}